package game;

import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;


public class WidgetSprite {
	
	private CustomImageDataII images[];
	private int frame;
	private int xPos, yPos;
	
	public WidgetSprite(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName) throws IOException {
		
		frame = 0;
		
		int totalFrames = Integer.MIN_VALUE;
		
		int frameForPopulating = 0;
		
		String inputter = null;
//		ImageIcon ii = null;
		Color transColor = null;
		
		String tempStrArray[] = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("/widget")) {
				return;
			} else if(inputter.contains("x:")) {
				xPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				yPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("frameCount:")) {
				totalFrames = Integer.parseInt(inputter.substring(11).trim());
				images = new CustomImageDataII[totalFrames];
			} else if(images != null) {
				tempStrArray = inputter.split("\\*");
				transColor = CustomImageData.translateFileInStringToColor(tempStrArray[1].trim());
//				ii = new ImageIcon(WidgetSprite.class.getResource(tempStrArray[0].trim()));
//				images[frameForPopulating] = new CustomImageDataII(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), transColor, ponyPanel);
				
//				if(tempStrArray[0].trim().contains("bottle dispensor") || tempStrArray[0].trim().contains("corker") || tempStrArray[0].trim().contains("collector")) {
//					CustomImageDataIIRepository.writeToLog("about to try load up a Widget for file: " + tempStrArray[0] + ", bgcolor: " + tempStrArray[1] + ", room name: " + roomName + ", length of array: " + tempStrArray.length + ", fromFiles?  " + fromFiles);
//				}
				
				if(fromFiles) {
					
					if(tempStrArray.length < 4)
						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, roomName, tempStrArray[0].trim());
						//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel);
					else
						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]), roomName, tempStrArray[0].trim());
						//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]));
					
				} else {
					
					if(tempStrArray.length < 4)
						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, roomName);
						//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel);
					else
						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]), roomName);
						//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]));
					
				}
				
				frameForPopulating++;
			}
			
		}
		
		
	}
	
	
	public void primeAll(Graphics g, int panelWidth, int panelHeight) {
//		for(CustomImageDataII cid : images) {
//			cid.primeImage(g, panelWidth, panelHeight);
//		}
	}
	
	
	
	public void draw(Graphics g, int playerX, int playerY, int panelWidth, int panelHeight) {
		
		images[frame].drawObject(g, panelWidth/2 + (xPos - playerX) , panelHeight/2 + (yPos - playerY));
		
	}
	
	
	public void update() {
		frame++;
		if(frame >= images.length) {
			frame = 0;
		}
	}
	
	public void resetFrameToZero() {
		frame = 0;
	}
	
	
	
	

	public static void retrieveFileLengths(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName, HashMap<String, Long> fileLengths) throws IOException {
		
//		frame = 0;
		
		int totalFrames = Integer.MIN_VALUE;
		
		int frameForPopulating = 0;
		
		String inputter = null;
//		ImageIcon ii = null;
		Color transColor = null;
		
		String tempStrArray[] = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("/widget")) {
				return;
			} else if(inputter.contains("x:")) {
//				xPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
//				yPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("frameCount:")) {
				totalFrames = Integer.parseInt(inputter.substring(11).trim());
//				images = new CustomImageDataII[totalFrames];
			} else if(totalFrames != Integer.MIN_VALUE) {
				tempStrArray = inputter.split("\\*");
				
				
				FileInputStream fis = new FileInputStream(new File(tempStrArray[0]));
				
				long lengthOfFile = 0L;
				
				while(fis.read() != -1)
					lengthOfFile++;
				
				fis.close();
				
				fileLengths.put(tempStrArray[0], lengthOfFile);
				
//				transColor = CustomImageData.translateFileInStringToColor(tempStrArray[1].trim());
//				ii = new ImageIcon(WidgetSprite.class.getResource(tempStrArray[0].trim()));
//				images[frameForPopulating] = new CustomImageDataII(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), transColor, ponyPanel);
				
//				if(tempStrArray[0].trim().contains("bottle dispensor") || tempStrArray[0].trim().contains("corker") || tempStrArray[0].trim().contains("collector")) {
//					CustomImageDataIIRepository.writeToLog("about to try load up a Widget for file: " + tempStrArray[0] + ", bgcolor: " + tempStrArray[1] + ", room name: " + roomName + ", length of array: " + tempStrArray.length + ", fromFiles?  " + fromFiles);
//				}
//				
//				if(fromFiles) {
//					
//					if(tempStrArray.length < 4)
//						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, roomName, tempStrArray[0].trim());
//						//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel);
//					else
//						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]), roomName, tempStrArray[0].trim());
//						//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]));
//					
//				} else {
//					
//					if(tempStrArray.length < 4)
//						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, roomName);
//						//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel);
//					else
//						images[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]), roomName);
//						//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel, Integer.parseInt(tempStrArray[2]), Integer.parseInt(tempStrArray[3]));
//					
//				}
//				
//				frameForPopulating++;
			}
			
		}
		
		
	}
	
}
